/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.treemodel;

import java.util.NoSuchElementException;
import java.util.Vector;
import jclass.datasource.treemodel.TreeIteratorModel;
import jclass.datasource.treemodel.TreeNodeModel;

public class TreeIterator
implements TreeIteratorModel {
    static final long serialVersionUID = -1011743164000120754L;
    protected int firstNode;
    protected int currentNode;
    protected Vector children;

    public TreeIterator(TreeNodeModel treeNodeModel) {
        TreeNodeModel treeNodeModel2 = treeNodeModel == null ? null : treeNodeModel.getParent();
        if (treeNodeModel2 == null) {
            this.children = new Vector();
            this.firstNode = 0;
        } else {
            this.children = treeNodeModel2.getChildren();
            this.firstNode = this.children.indexOf(treeNodeModel);
        }
        this.currentNode = this.firstNode;
    }

    public Object nextElement() {
        Object object = this.get();
        this.advance();
        return object;
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public boolean atBegin() {
        return this.currentNode == this.firstNode;
    }

    public Object get() {
        if (!this.atEnd()) {
            return this.children.elementAt(this.currentNode);
        }
        throw new NoSuchElementException("TreeIterator");
    }

    public void advance(int n) {
        if (n >= this.firstNode && n < this.children.size()) {
            this.currentNode = n;
        }
    }

    public Object clone() {
        return null;
    }

    public boolean atEnd() {
        return true;
    }

    public void advance() {
    }
}

